<?xml version="1.0"?>

<st-source>
<time-stamp>From VisualWorks® NonCommercial, 7.7.1 of 2010年7月26日 on 2010年8月5日 at 13:48:47</time-stamp>


<component-created>
<name>SSK</name> <type>package</type>
</component-created><!-- Package SSK* -->


<component-property>
<name>SSK</name> <type>package</type>
<property>comment</property> <value>'Smalltalk Studies in Kyoto'</value>
</component-property>

<class>
<name>OldFashionedBrowser</name>
<environment>Smalltalk</environment>
<super>UI.ApplicationModel</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>classTable instanceMethodTable classMethodTable classList </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category></category>
<attributes>
<package>SSK</package>
</attributes>
</class>

<comment>
<class-id>OldFashionedBrowser</class-id>
<body>Smalltalk Studies in Kyoto</body>
</comment>

<methods>
<class-id>OldFashionedBrowser class</class-id> <category>interface specs</category>

<body package="SSK" selector="windowSpec">windowSpec
	"Tools.UIPainter new openOnClass: self andSelector: #windowSpec"

	&lt;resource: #canvas&gt;
	^#(#{UI.FullSpec} 
		#window: 
		#(#{UI.WindowSpec} 
			#label: 'Old Fashioned Browser' 
			#min: #(#{Core.Point} 400 300 ) 
			#max: #(#{Core.Point} 0 0 ) 
			#bounds: #(#{Graphics.Rectangle} 640 313 1240 763 ) ) 
		#component: 
		#(#{UI.SpecCollection} 
			#collection: #(
				#(#{UI.SequenceViewSpec} 
					#layout: #(#{Graphics.LayoutFrame} 8 0 8 0 -4 0.5 -4 0.5 ) 
					#name: #classList 
					#model: #classList 
					#callbacksSpec: 
					#(#{UI.UIEventCallbackSubSpec} 
						#valueChangeSelector: #classListSelectionChanged ) 
					#useModifierKeys: true 
					#selectionType: #highlight ) ) ) )</body>
</methods>

<methods>
<class-id>OldFashionedBrowser class</class-id> <category>examples</category>

<body package="SSK" selector="example">example
	"OldFashionedBrowser example."

	| aBrowser |
	aBrowser := OldFashionedBrowser new.
	aBrowser open.
	^aBrowser</body>
</methods>


<methods>
<class-id>OldFashionedBrowser</class-id> <category>aspects</category>

<body package="SSK" selector="classListSelectionChanged">classListSelectionChanged

	Transcript
		cr;
		nextPutAll: thisContext printString;
		crtab;
		nextPutAll: classList selection printString;
		flush</body>
</methods>

<methods>
<class-id>OldFashionedBrowser</class-id> <category>accessing</category>

<body package="SSK" selector="classList">classList

	classList list isEmpty ifFalse: [^classList].
	classList list: instanceMethodTable keys asSortedCollection.
	^classList</body>
</methods>

<methods>
<class-id>OldFashionedBrowser</class-id> <category>initialize-release</category>

<body package="SSK" selector="initialize">initialize

	super initialize.
	classTable := Dictionary new: 1000.
	instanceMethodTable := Dictionary new: 1000.
	classMethodTable := Dictionary new: 1000.
	SystemUtils allClassesDo: 
			[:aClass |
			classTable at: aClass name put: aClass.
			instanceMethodTable at: aClass name put: aClass selectors asSortedCollection.
			classMethodTable at: aClass name
				put: aClass class selectors asSortedCollection].
	classList := SelectionInList new.
	^self</body>
</methods>



</st-source>
